<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormSuggestCategory()
  ===================================================*/

  function ShowFormSuggestCategory() {

    // vars global configuration
    global $dbConn, $theme_path, $category_separator;

    // vars url & form
    global $parent, $cat_name, $cat_desc;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    $category_obj             = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->separator  = $category_separator;
    $parent                   = str_replace("<select name=\"cat\">","<select name=\"parent\">", $category_obj->DisplayCategoryListBox($parent, true));

    $cat_name = htmlspecialchars(stripslashes($cat_name));
    $cat_desc = htmlspecialchars(stripslashes($cat_desc));

    DisplayTemplate($theme_path . "suggest_category_form.html", "\$error_msg,\$parent,\$cat_name,\$cat_desc");
  }


  /*===================================================
    ProcessFormSuggestCategory()
  ===================================================*/

  function ProcessFormSuggestCategory() {

    // vars global configuration
    global $dbConn, $theme_path, $category_separator, $email_address;

    // vars url & form
    global $error_msg, $cat_name, $cat_desc, $parent;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    // verify input

    if (empty($cat_name)) {
      $error_msg = $msg["20201"];
    }

    if (empty($error_msg)) {

      $category_obj             = new clsCategory;
      $category_obj->table_name = "idx_category";
      $category_obj->separator  = $category_separator;
      if ($parent) {
        $parent                 = $msg["10011"] . $category_obj->separator . $category_obj->GetCategoryPath($parent);
      }
      else {
        $parent                 = $msg["10011"];
      }

      $body = EvalTemplate($theme_path . "mail/suggest_category.mail", "\$parent,\$cat_name,\$cat_desc");
      $from = $email_address;
      @mail($email_address, $msg["20202"], $body, "From: $from\nX-Mailer: INDEXU_X-Mailer/1.0");
      DisplayTemplate($theme_path . "suggest_category_ok.html");
    }
    else {
      ShowFormSuggestCategory();
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormSuggestCategory();
  }
  elseif ($pflag == 'send') {
    ProcessFormSuggestCategory();
  }

  RunPostFilter(__FILE__);

?>